﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NovelInterpreter.Interpreter.Enum
{
	/// <summary>
	/// 構文の実行時に返却されるデータ
	/// 構文自体はゲームにおける状態遷移と同じ動作を行う
	/// </summary>
	public class InvokeResult
	{
		/// <summary>
		/// コンテナ側に知らせるためのデータ
		/// リセットする場合、どうやってリセットするかを指定する
		/// 主にコンストラクタで使用する値をセットする
		/// 0番に構文番号をセットしてはいけない
		/// </summary>
		/// <example>
		/// コンストラクタの順番に入れる
		/// Hoge(int, string) => object[] {0, "hoge"}
		/// </example>
		public List<object> suggestForContainerData;

		/// <summary>
		/// 返却値の種類
		/// </summary>
		public enum ResultType
		{
			/// <summary>
			/// 次の構文へ遷移
			/// </summary>
			Next,

			/// <summary>
			/// 遷移せずにもう一度実行する
			/// </summary>
			InvokeOnce,

			/// <summary>
			/// 構文終了時に構文の情報をリセットして次へ遷移する
			/// </summary>
			ResetNext
		}

		/// <summary>
		/// 次にInvokeされた時にどう処理するか
		/// </summary>
		public ResultType nextInvokeType;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="type">次に遷移する状態</param>
		public InvokeResult(ResultType type)
		{
			this.suggestForContainerData = new List<object>();
			this.nextInvokeType = type;
		}
	}
}
